// Content script - roda em todas as páginas do TikTok
// Repassa mensagens do script injetado para o popup

console.log('TikTok Shop Extractor - Extensão carregada');

// Listener para mensagens do popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'ping') {
        sendResponse({ status: 'ok' });
    }
    return true;
});

// Escuta mensagens do script injetado e salva no storage
window.addEventListener('message', (event) => {
    // Verifica se a mensagem é da extensão
    if (event.data && event.data.type === 'extraction-update') {
        try {
            // Salva a atualização no storage local
            const updateData = {
                updateType: event.data.updateType,
                message: event.data.message,
                data: event.data.data,
                timestamp: Date.now()
            };
            
            // Salva no storage (não precisa de listener ativo)
            chrome.storage.local.set({
                'extraction-update': updateData
            }).catch(err => {
                console.warn('Erro ao salvar no storage:', err);
            });
            
            // Tenta enviar via message também (se popup estiver aberto)
            chrome.runtime.sendMessage(event.data).catch(() => {
                // Ignora silenciosamente se popup não estiver aberto
            });
        } catch (err) {
            console.warn('Erro ao processar mensagem:', err);
        }
    }
});
